# Attack Searchers
## Table of Contents
- Attack Searchers
	 - [Suffix Searchers](#suffix-searchers)
	 - [Prompt Searchers](#prompt-searchers)
		 - [Language Model](#language-model)
		 - [Decoding](#decoding)
		 - [Genetic Algorithm](#genetic-algorithm)
		 - [Reinforcement Learning](#reinforcement-learning)
## Suffix Searchers
- **Prompting4Debugging: Red-Teaming Text-to-Image Diffusion Models by Finding Problematic Prompts** \[[Paper](https://arxiv.org/abs/2309.06135)\] <br />
Zhi-Yi Chin,  Chieh-Ming Jiang,  Ching-Chun Huang,  Pin-Yu Chen,  Wei-Chen Chiu (2023)<br />
- **White-box Multimodal Jailbreaks Against Large Vision-Language Models** \[[Paper](https://arxiv.org/abs/2405.17894
   )\] <br />
Ruofan Wang,  Xingjun Ma,  Hanxu Zhou,  Chuanjun Ji,  Guangnan Ye,  Yu-Gang Jiang (2024)<br />
- **AmpleGCG: Learning a Universal and Transferable Generative Model of Adversarial Suffixes for Jailbreaking Both Open and Closed LLMs** \[[Paper](https://arxiv.org/abs/2404.07921
   )\] <br />
Zeyi Liao,  Huan Sun (2024)<br />
- **Improved Techniques for Optimization-Based Jailbreaking on Large Language Models** \[[Paper](https://arxiv.org/abs/2405.21018
   )\] <br />
Xiaojun Jia,  Tianyu Pang,  Chao Du,  Yihao Huang,  Jindong Gu,  Yang Liu,  Xiaochun Cao,  Min Lin (2024)<br />
- **AdvPrompter: Fast Adaptive Adversarial Prompting for LLMs** \[[Paper](https://arxiv.org/abs/2404.16873
   )\] <br />
Anselm Paulus,  Arman Zharmagambetov,  Chuan Guo,  Brandon Amos,  Yuandong Tian (2024)<br />
- **Learning diverse attacks on large language models for robust red-teaming and safety tuning** \[[Paper](https://arxiv.org/abs/2405.18540
   )\] <br />
Seanie Lee,  Minsu Kim,  Lynn Cherif,  David Dobre,  Juho Lee,  Sung Ju Hwang,  Kenji Kawaguchi,  Gauthier Gidel,  Yoshua Bengio,  Nikolay Malkin,  Moksh Jain (2024)<br />
- **Efficient Black-box Adversarial Attacks via Bayesian Optimization Guided by a Function Prior** \[[Paper](https://arxiv.org/abs/2405.19098
   )\] <br />
Shuyu Cheng,  Yibo Miao,  Yinpeng Dong,  Xiao Yang,  Xiao-Shan Gao,  Jun Zhu (2024)<br />
- **Automatic and Universal Prompt Injection Attacks against Large Language Models** \[[Paper](https://arxiv.org/abs/2403.04957)\] <br />
Xiaogeng Liu,  Zhiyuan Yu,  Yizhe Zhang,  Ning Zhang,  Chaowei Xiao (2024)<br />
- **Jailbreaking Leading Safety-Aligned LLMs with Simple Adaptive Attacks** \[[Paper](https://arxiv.org/abs/2404.02151)\] <br />
Maksym Andriushchenko,  Francesco Croce,  Nicolas Flammarion (2024)<br />
- **Neural Exec: Learning (and Learning from) Execution Triggers for Prompt Injection Attacks** \[[Paper](https://arxiv.org/abs/2403.03792)\] <br />
Dario Pasquini,  Martin Strohmeier,  Carmela Troncoso (2024)<br />
- **$\textit{LinkPrompt}$: Natural and Universal Adversarial Attacks on Prompt-based Language Models** \[[Paper](https://arxiv.org/abs/2403.16432)\] <br />
Yue Xu,  Wenjie Wang (2024)<br />
- **Rapid Optimization for Jailbreaking LLMs via Subconscious Exploitation and Echopraxia** \[[Paper](https://arxiv.org/abs/2402.05467)\] <br />
Guangyu Shen,  Siyuan Cheng,  Kaiyuan Zhang,  Guanhong Tao,  Shengwei An,  Lu Yan,  Zhuo Zhang,  Shiqing Ma,  Xiangyu Zhang (2024)<br />
- **Fast Adversarial Attacks on Language Models In One GPU Minute** \[[Paper](https://arxiv.org/abs/2402.1557)\] <br />
Vinu Sankar Sadasivan,  Shoumik Saha,  Gaurang Sriramanan,  Priyatham Kattakinda,  Atoosa Chegini,  Soheil Feizi (2024)<br />
- **From Noise to Clarity: Unraveling the Adversarial Suffix of Large Language Model Attacks via Translation of Text Embeddings** \[[Paper](https://arxiv.org/abs/2402.16006)\] <br />
Hao Wang,  Hao Li,  Minlie Huang,  Lei Sha (2024)<br />
- **Gradient-Based Language Model Red Teaming** \[[Paper](https://arxiv.org/abs/2401.16656)\] <br />
Nevan Wichers,  Carson Denison,  Ahmad Beirami (2024)<br />
- **AutoDAN: Generating Stealthy Jailbreak Prompts on Aligned Large Language Models** \[[Paper](https://arxiv.org/abs/2310.04451)\] <br />
Xiaogeng Liu,  Nan Xu,  Muhao Chen,  Chaowei Xiao (2023)<br />
- **AutoDAN: Interpretable Gradient-Based Adversarial Attacks on Large Language Models** \[[Paper](https://arxiv.org/abs/2310.1514)\] <br />
Sicheng Zhu,  Ruiyi Zhang,  Bang An,  Gang Wu,  Joe Barrow,  Zichao Wang,  Furong Huang,  Ani Nenkova,  Tong Sun (2023)<br />
- **Universal and Transferable Adversarial Attacks on Aligned Language Models** \[[Paper](https://arxiv.org/abs/2307.15043)\] <br />
Andy Zou,  Zifan Wang,  Nicholas Carlini,  Milad Nasr,  J. Zico Kolter,  Matt Fredrikson (2023)<br />
- **Soft-prompt Tuning for Large Language Models to Evaluate Bias** \[[Paper](https://arxiv.org/abs/2306.04735)\] <br />
Jacob-Junqi Tian,  David Emerson,  Sevil Zanjani Miyandoab,  Deval Pandya,  Laleh Seyyed-Kalantari,  Faiza Khan Khattak (2023)<br />
- **TrojLLM: A Black-box Trojan Prompt Attack on Large Language Models** \[[Paper](https://arxiv.org/abs/2306.06815)\] <br />
Jiaqi Xue,  Mengxin Zheng,  Ting Hua,  Yilin Shen,  Yepeng Liu,  Ladislau Boloni,  Qian Lou (2023)<br />
## Prompt Searchers
### Language Model
- **Automatic Jailbreaking of the Text-to-Image Generative AI Systems** \[[Paper](https://arxiv.org/abs/2405.16567
   )\] <br />
Minseon Kim,  Hyomin Lee,  Boqing Gong,  Huishuai Zhang,  Sung Ju Hwang (2024)<br />
- **ART: Automatic Red-teaming for Text-to-Image Models to Protect Benign Users** \[[Paper](https://arxiv.org/abs/2405.19360
   )\] <br />
Guanlin Li,  Kangjie Chen,  Shudong Zhang,  Jie Zhang,  Tianwei Zhang (2024)<br />
- **Eliciting Language Model Behaviors using Reverse Language Models** \[[Paper](https://openreview.net/pdf?id=m6xyTie61H)\] <br />
Jacob Pfau,  Alex Infanger,  Abhay Sheshadri,  Ayush Panda,  Julian Michael,  Curtis Huebner

 (2023)<br />
- **No Offense Taken: Eliciting Offensiveness from Language Models** \[[Paper](https://arxiv.org/abs/2310.00892)\] <br />
Anugya Srivastava,  Rahul Ahuja,  Rohith Mukku (2023)<br />
- **LoFT: Local Proxy Fine-tuning For Improving Transferability Of Adversarial Attacks Against Large Language Model** \[[Paper](https://arxiv.org/abs/2310.04445)\] <br />
Muhammad Ahmed Shah,  Roshan Sharma,  Hira Dhamyal,  Raphael Olivier,  Ankit Shah,  Joseph Konan,  Dareen Alharthi,  Hazim T Bukhari,  Massa Baali,  Soham Deshmukh,  Michael Kuhlmann,  Bhiksha Raj,  Rita Singh (2023)<br />
- **Jailbreaking Black Box Large Language Models in Twenty Queries** \[[Paper](https://arxiv.org/abs/2310.08419)\] <br />
Patrick Chao,  Alexander Robey,  Edgar Dobriban,  Hamed Hassani,  George J. Pappas,  Eric Wong (2023)<br />
- **An LLM can Fool Itself: A Prompt-Based Adversarial Attack** \[[Paper](https://arxiv.org/abs/2310.13345)\] <br />
Xilie Xu,  Keyi Kong,  Ning Liu,  Lizhen Cui,  Di Wang,  Jingfeng Zhang,  Mohan Kankanhalli (2023)<br />
- **Red Teaming Language Models with Language Models** \[[Paper](https://arxiv.org/abs/2202.03286)\] <br />
Ethan Perez,  Saffron Huang,  Francis Song,  Trevor Cai,  Roman Ring,  John Aslanides,  Amelia Glaese,  Nat McAleese,  Geoffrey Irving (2022)<br />
- **JAB: Joint Adversarial Prompting and Belief Augmentation** \[[Paper](https://arxiv.org/abs/2311.09473)\] <br />
Ninareh Mehrabi,  Palash Goyal,  Anil Ramakrishna,  Jwala Dhamala,  Shalini Ghosh,  Richard Zemel,  Kai-Wei Chang,  Aram Galstyan,  Rahul Gupta (2023)<br />
- **DALA: A Distribution-Aware LoRA-Based Adversarial Attack against Language Models** \[[Paper](https://arxiv.org/abs/2311.08598)\] <br />
Yibo Wang,  Xiangjue Dong,  James Caverlee,  Philip S. Yu (2023)<br />
- **AART: AI-Assisted Red-Teaming with Diverse Data Generation for New LLM-powered Applications** \[[Paper](https://arxiv.org/abs/2311.08592)\] <br />
Bhaktipriya Radharapu,  Kevin Robinson,  Lora Aroyo,  Preethi Lahoti (2023)<br />
- **Tree of Attacks: Jailbreaking Black-Box LLMs Automatically** \[[Paper](https://arxiv.org/abs/2312.02119)\] <br />
Anay Mehrotra,  Manolis Zampetakis,  Paul Kassianik,  Blaine Nelson,  Hyrum Anderson,  Yaron Singer,  Amin Karbasi (2023)<br />
- **GPT-4 Jailbreaks Itself with Near-Perfect Success Using Self-Explanation** \[[Paper](https://arxiv.org/abs/2405.13077
   )\] <br />
Govind Ramesh,  Yao Dou,  Wei Xu (2024)<br />
- **Adversarial Attacks on GPT-4 via Simple Random Search** \[[Paper](https://arxiv.org/abs/2404.0553)\] <br />
Tim Baumgärtner,  Yang Gao,  Dana Alon,  Donald Metzler (2024)<br />
- **Tastle: Distract Large Language Models for Automatic Jailbreak Attack** \[[Paper](https://arxiv.org/abs/2403.08424)\] <br />
Zeguan Xiao,  Yan Yang,  Guanhua Chen,  Yun Chen (2024)<br />
- **All in How You Ask for It: Simple Black-Box Method for Jailbreak Attacks** \[[Paper](https://arxiv.org/abs/2401.09798)\] <br />
Kazuhiro Takemoto (2024)<br />
### Decoding
- **Lockpicking LLMs: A Logit-Based Jailbreak Using Token-level Manipulation** \[[Paper](https://arxiv.org/abs/2405.13068
   )\] <br />
Yuxi Li,  Yi Liu,  Yuekang Li,  Ling Shi,  Gelei Deng,  Shengquan Chen,  Kailong Wang (2024)<br />
- **Weak-to-Strong Jailbreaking on Large Language Models** \[[Paper](https://arxiv.org/abs/2401.17256)\] <br />
Xuandong Zhao,  Xianjun Yang,  Tianyu Pang,  Chao Du,  Lei Li,  Yu-Xiang Wang,  William Yang Wang (2024)<br />
- **COLD-Attack: Jailbreaking LLMs with Stealthiness and Controllability** \[[Paper](https://arxiv.org/abs/2402.08679)\] <br />
Xingang Guo,  Fangxu Yu,  Huan Zhang,  Lianhui Qin,  Bin Hu (2024)<br />
### Genetic Algorithm
- **Semantic Mirror Jailbreak: Genetic Algorithm Based Jailbreak Prompts Against Open-source LLMs** \[[Paper](https://arxiv.org/abs/2402.14872)\] <br />
Xiaoxia Li,  Siyuan Liang,  Jiyi Zhang,  Han Fang,  Aishan Liu,  Ee-Chien Chang (2024)<br />
- **Open Sesame! Universal Black Box Jailbreaking of Large Language Models** \[[Paper](https://arxiv.org/abs/2309.01446)\] <br />
Raz Lapid,  Ron Langberg,  Moshe Sipper (2023)<br />
### Reinforcement Learning
- **SneakyPrompt: Jailbreaking Text-to-image Generative Models** \[[Paper](https://arxiv.org/abs/2305.12082)\] <br />
Yuchen Yang,  Bo Hui,  Haolin Yuan,  Neil Gong,  Yinzhi Cao (2023)<br />
- **RL-JACK: Reinforcement Learning-powered Black-box Jailbreaking Attack against LLMs** \[[Paper](https://arxiv.org/abs/2406.08725
   )\] <br />
Xuan Chen,  Yuzhou Nie,  Lu Yan,  Yunshu Mao,  Wenbo Guo,  Xiangyu Zhang (2024)<br />
- **When LLM Meets DRL: Advancing Jailbreaking Efficiency via DRL-guided Search** \[[Paper](https://arxiv.org/abs/2406.08705
   )\] <br />
Xuan Chen,  Yuzhou Nie,  Wenbo Guo,  Xiangyu Zhang (2024)<br />
- **QROA: A Black-Box Query-Response Optimization Attack on LLMs** \[[Paper](https://arxiv.org/abs/2406.02044
   )\] <br />
Hussein Jawad,  Nicolas J. -B. BRUNEL (2024)<br />
- **Unveiling the Implicit Toxicity in Large Language Models** \[[Paper](https://arxiv.org/abs/2311.17391)\] <br />
Jiaxin Wen,  Pei Ke,  Hao Sun,  Zhexin Zhang,  Chengfei Li,  Jinfeng Bai,  Minlie Huang (2023)<br />
- **Red Teaming Game: A Game-Theoretic Framework for Red Teaming Language Models** \[[Paper](https://arxiv.org/abs/2310.00322)\] <br />
Chengdong Ma,  Ziran Yang,  Minquan Gao,  Hai Ci,  Jun Gao,  Xuehai Pan,  Yaodong Yang (2023)<br />
- **Explore,Establish,Exploit: Red Teaming Language Models from Scratch** \[[Paper](https://arxiv.org/abs/2306.09442)\] <br />
Stephen Casper,  Jason Lin,  Joe Kwon,  Gatlen Culp,  Dylan Hadfield-Menell (2023)<br />